<?php
defined('PF_VERSION') OR exit('Access denied');
$current = isset($_GET['current']) ? (int)$_GET['current'] : '';
?>
<div class="hidden" id="messageErrorJS">
    <ul>
        <li class="confirmDelete"><?php echo __('Are you sure to delete this comment?', 'comment'); ?></li>
        <li class="notChecked"><?php echo __('No comment is selected', 'comment'); ?></li>
        <li class="confirmBulkAction"><?php echo __('Are you sure to perform this action?', 'comment'); ?></li>
        <li class="errorSearch"><?php echo __('Please enter a search term', 'comment'); ?></li>
        <li class="errorSelectAuthor"><?php echo __('Please choose an author', 'comment'); ?></li>
        <li class="validatorContent"><?php echo __('Content must be at least 2 characters and no more than 500 characters', 'comment'); ?></li>
        <li class="validatorID"><?php echo __('Incorrect ID', 'comment'); ?></li>
        <li class="saveEditSuccess"><?php echo __('Comment is updated successfully', 'comment'); ?></li>
        <li class="saveEditError"><?php echo __('There was an error Please try again', 'comment'); ?></li>
    </ul>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Comments', 'comment'); ?></h3>
            </div>

            <div class="panel-body">
                <div class="modal fade" id="editComment" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <form class="form-horizontal" role="form" method="post" accept-charset="utf-8">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                                    <h4 class="modal-title" id="myModalLabel"><?php echo __('Edit comment', 'comment'); ?></h4>
                                </div>
                                <div class="modal-body">
                                    <div id="alertMessage">

                                    </div>
                                    <div class="form-group">
                                        <label for="name" class="col-sm-12"><?php echo __('Content', 'comment'); ?> <span>*</span></label>
                                        <div class="col-sm-12">
                                            <?php
                                            echo form_textarea(array('name' => 'content', 'class' => 'form-control'));
                                            ?>
                                            <input type="hidden" name="id" value=""/>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo __('Close', 'comment'); ?></button>
                                    <button type="button" class="btn btn-primary" id="btnSaveEdit"><?php echo __('Save', 'comment'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div><!--end add category -->

                <?php require_once ABSPATH . '/includes/common/plugin/views/alert.php'; ?>
                <div class="row margin-bottom-20">
                    <div class="col-sm-7">
                        <ul class="list-unstyled topControl">
                            <li id="bulkAction">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                        <?php echo __('Select Action ', 'comment'); ?> <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li data-action="3"><a href="#"><?php echo __('Delete', 'comment'); ?></a></li>
                                        <li data-action="1"><a href="#"><?php echo __('Publish', 'comment'); ?></a></li>
                                        <li data-action="0"><a href="#"><?php echo __('Unpublish', 'comment'); ?></a></li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-5 miniSearch">
                        <div class="input-group">
                            <input type="text" class="form-control" name="kw" value="<?php echo get_value_search(); ?>" placeholder="<?php echo __('Please enter the search conditions', 'comment'); ?>">
                            <span class="input-group-btn">
                                <button class="btn btn-default btn-flat" type="button" id="btnMiniSearch">
                                    <i class="fa fa-search"></i> <?php echo __('Search', 'comment') ?>
                                </button>
                                <a class="btn btn-default btn-flat" href="<?php echo admin_url('admin-page=comment', false); ?>">
                                    <i class="fa fa-times-circle"></i>
                                </a>
                            </span>
                        </div><!-- /input-group -->
                    </div><!--end #search-->
                </div>

                <div class="row margin-bottom-10">
                    <div class="col-md-6">
                        <ul class="list-unstyled filer">
                            <li class="filterByStatus">                        
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                        <?php printf(__('%s', 'comment'), show_status_filter()); ?> <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="<?php echo admin_url('admin-page=comment', false); ?>"><?php echo __('All', 'comment'); ?></a></li>
                                        <li><a href="<?php echo admin_url('admin-page=comment&status=1', false); ?>"><?php echo __('Published', 'comment'); ?></a></li>
                                        <li><a href="<?php echo admin_url('admin-page=comment&status=2', false); ?>"><?php echo __('Unpublished', 'comment'); ?></a></li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <div class="pull-right">
                            <?php echo $pagination->short_page_link(); ?>
                        </div>
                    </div>
                </div><!--end row-->

                <form method="post" role="form" action="<?php echo admin_url('&act=bulk_action'); ?>" id="listComments">
                    <input type="hidden" value="1" name="action"/>
                    <input type="hidden" value="<?php echo $current ?>" name="current"/>
                    <table class="bootstrap-table">
                        <tr>
                            <th data-fixed="left">
                                <input type="checkbox" id="checkAll"/>
                            </th>
                            <th><?php echo __('Content', 'comment'); ?></th>
                            <th style="width: 150px;"><?php echo __('Author', 'comment'); ?></th>
                            <th style="width: 140px;"><?php echo __('Comment date', 'comment'); ?></th>
                            <th style="width: 90px;"><?php echo __('Status', 'comment'); ?></th>
                            <th data-fixed="right"><?php echo __('Actions', 'comment'); ?></th>
                        </tr>
                        <?php
                        if (isset($comments) && count($comments)):
                            foreach ($comments as $comment):
                                $type = $comment->comment_status == 1 ? 2 : 1;
                                ?> 
                                <tr data-id="<?php echo $comment->id ?>">
                                    <td>
                                        <input type="checkbox" name="id[]" class="itemCheckBox" value="<?php echo $comment->id ?>"/>
                                    </td>
                                    <td class="commentContent">
                                        <?php echo e($comment->comment_content); ?>
                                    </td>
                                    <td>
                                        <?php echo $comment->comment_author ?>
                                    </td>
                                    <td>
                                        <?php echo convert_date($comment->comment_created_date, get_configuration('short_date')); ?>
                                    </td>
                                    <td>
                                        <?php echo show_status(admin_url("admin-page=comment&act=status&id={$comment->id}&type=$type&current={$current}", false), $comment->comment_status); ?>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-info btn-xs" data-id="<?php echo $comment->id ?>" title="<?php echo __('Edit comment', 'comment'); ?>" name="btnEdit"><i class="fa fa-edit"></i></button>
                                        <a class="btn btn-danger btn-xs confirmationDelete" href="<?php echo admin_url("admin-page=comment&act=delete&id={$comment->id}", false); ?>" title="<?php echo __('Delete', 'comment'); ?>"><i class="fa fa-trash-o"></i></a>
                                    </td>
                                </tr>
                                <?php
                            endforeach;
                        endif;
                        ?>
                    </table>
                </form>
            </div><!---end .panel-body-->
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-6">
                        <?php echo $pagination->page_lable(); ?>
                    </div>
                    <div class="col-md-6">
                        <div class="pull-right">
                            <?php echo $pagination->page_links($url . '&'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="hidden" id="control-clone">
    <div class="alert alert-block">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <div class="bodyMessage">

        </div>
    </div>
</div>